<?php
include "config.php";
if (!isset($_SESSION["admin"])) {
    header("Location: login.php");
    exit;
}

$file = __DIR__ . "/settings.json";
if (!file_exists($file)) {
    file_put_contents($file, json_encode(["background" => ""], JSON_PRETTY_PRINT));
}
$data = json_decode(file_get_contents($file), true);

$msg = "";
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $bgUrl = $_POST["background"];
    $data["background"] = $bgUrl;
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    $msg = "Background berhasil diperbarui!";
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Kelola Background</title>
    <style>
        body { font-family: Arial, sans-serif; margin:20px; }
        .box { background:#fff; padding:20px; border:1px solid #ccc; max-width:600px; }
        .msg { color:green; font-weight:bold; }
        input[type=text] { width:100%; padding:8px; margin:5px 0; }
        button { padding:8px 14px; background:#3498db; color:#fff; border:none; border-radius:4px; cursor:pointer; }
        button:hover { background:#2980b9; }
    </style>
</head>
<body>
<h2>🖼 Kelola Background</h2>
<?php if (!empty($msg)) echo "<p class='msg'>$msg</p>"; ?>
<div class="box">
    <form method="post">
        <label>URL Gambar Background</label><br>
        <input type="text" name="background" value="<?php echo htmlspecialchars($data["background"]); ?>" placeholder="https://example.com/bg.jpg">
        <br><br>
        <button type="submit">💾 Simpan</button>
        <a href="dashboard.php" style="margin-left:10px;">⬅ Kembali</a>
    </form>
</div>
<?php if (!empty($data["background"])): ?>
    <h3>Preview:</h3>
    <div style="width:100%;height:300px;background:url('<?php echo $data["background"]; ?>') center/cover no-repeat;border:1px solid #ccc;"></div>
<?php endif; ?>
</body>
</html>
